define([
    'underscore',
    'Vent',
    'modules/community-care-request/view/community-care-view',
    'modules/new-appointment-wizard/wizard-step-model',
    'modules/community-care-request/new-appointment-request-question/preferred-provider/preferences/preferred-provider-section-view', // eslint-disable-line max-len
    'modules/community-care-request/new-appointment-request-question/preferred-provider/choices/choice-layout-view', // eslint-disable-line max-len
    'modules/community-care-request/new-appointment-request-question/notification-selection/community-care-notification-settings-layout-view', // eslint-disable-line max-len
    'modules/community-care-request/new-appointment-request-question/preferred-provider/choices/additional-preference-section-view', // eslint-disable-line max-len
    'text!modules/community-care-request/new-appointment-request-question/preferred-provider/preferred-provider-layout.html', // eslint-disable-line max-len
],
function(
    _,
    vent,
    CommunityCareView,
    WizardStepModel,
    PrimaryCareSectionView,
    PrimaryProviderLayoutView,
    CCNotificationSettingsLayout,
    AdditionalPreference,
    template
) {
    'use strict';
    return CommunityCareView.extend({
        template: _.template(template),
        regions: {
            primaryLocation: '.primary-care-request',
            primaryProvider: '.primary-provider',
            additionalPreference: '.additonal-preferences',
        },
        modelEvents: {
            'change:primaryCity': 'handleModelChange',
            'change:primaryState': 'handleModelChange',
            'change:primaryZipCode': 'handleModelChange',
            'change:primaryPreferredMiles': 'handleModelChange',
            'change:preferredLanguageSpoken': 'handleModelChange',
            'change:officeHours': 'handleModelChange',
        },
        initialize: function(options) {
            if (_.isUndefined(options)) {
                this.model = new WizardStepModel.Model();
            } else {
                this.model = options.model;
                this.validator = options.validator;
                this.isValid = options.isValid;
                if (!(this.model.get('primaryCity')
                        || this.model.get('primaryState')
                        || this.model.get('primaryZipCode'))) {
                    this.ifAddressSetModel();
                }
            }
        },
        onRender: function() {
            this.showPrimaryCare();
            this.showPrimaryProvider();
            this.showAdditionPreference();
            // we initialize a handle to the buttons and disable

            this.disableContinueButton();
            // if all the required fields are met, we enable
            this.handleModelChange();
        },
        showPrimaryCare: function() {
            this.showChildView('primaryLocation', new PrimaryCareSectionView({model: this.model}));
        },
        showPrimaryProvider: function() {
            this.showChildView('primaryProvider', new PrimaryProviderLayoutView({model: this.model}));
        },
        showAdditionPreference: function() {
            this.showChildView('additionalPreference', new AdditionalPreference({model: this.model}));
        },
        toContinue: function(e) {
            if (this.isValid()) {
                if (_.isEmpty(this.model.get('primaryZipCode'))) {
                    this.model.unset('primaryZipCode');
                }
                vent.trigger('show:nextWizardPage', CCNotificationSettingsLayout, 1);
            }
        },
        ifAddressSetModel: function() {
            var primaryZipCode;
            if (this.model.get('address')) {
                primaryZipCode = this.model.get('primaryZipCode');
                this.model.set('primaryCity', this.model.get('city'));
                this.model.set('primaryState', this.model.get('state'));
                this.model.set('primaryZipCode',
                    primaryZipCode ? primaryZipCode : this.model.get('zipCode'));
            }
        },
    });
});
